---
description: "Learn more about: Text functions"
title: "Text functions (DAX) | Microsoft Docs"
---
# Text functions

Data Analysis Expressions (DAX) includes a set of text functions based on the library of string functions in Excel, but which have been modified to work with tables and columns in tabular models. This section describes text functions available in the DAX language.  
  
## In this category

|Function  |Description  |
|---------|---------|
|[COMBINEVALUES](combinevalues-function-dax.md)     |   Joins two or more text strings into one text string.       |
|[CONCATENATE](concatenate-function-dax.md)     | Joins two text strings into one text string.         |
|[CONCATENATEX](concatenatex-function-dax.md)      | Concatenates the result of an expression evaluated for each row in a table.          |
|[EXACT](exact-function-dax.md)      | Compares two text strings and returns TRUE if they are exactly the same, FALSE otherwise.        |
|[FIND](find-function-dax.md)     |  Returns the starting position of one text string within another text string.       |
|[FIXED](fixed-function-dax.md)     | Rounds a number to the specified number of decimals and returns the result as text.        |
|[FORMAT](format-function-dax.md)    |  Converts a value to text according to the specified format.         |
|[LEFT](left-function-dax.md)     |  Returns the specified number of characters from the start of a text string.         |
|[LEN](len-function-dax.md)    |  Returns the number of characters in a text string.         |
|[LOWER](lower-function-dax.md)     | Converts all letters in a text string to lowercase.         |
|[MID](mid-function-dax.md)     | Returns a string of characters from the middle of a text string, given a starting position and length.         |
|[REPLACE](replace-function-dax.md)     | REPLACE replaces part of a text string, based on the number of characters you specify, with a different text string.          |
|[REPT](rept-function-dax.md)     |  Repeats text a given number of times.        |
|[RIGHT](right-function-dax.md)    |  RIGHT returns the last character or characters in a text string, based on the number of characters you specify.         |
|[SEARCH](search-function-dax.md)    |  Returns the number of the character at which a specific character or text string is first found, reading left to right.       |
|[SUBSTITUTE](substitute-function-dax.md)     |  Replaces existing text with new text in a text string.         |
|[TRIM](trim-function-dax.md)      |  Removes all spaces from text except for single spaces between words.         |
|[UNICHAR](unichar-function-dax.md)    |  Returns the Unicode character referenced by the numeric value.       |
|[UNICODE](unicode-function-dax.md)    |  Returns the numeric code corresponding to the first character of the text string.       |
|[UPPER](upper-function-dax.md)    |  Converts a text string to all uppercase letters.         |
|[VALUE](value-function-dax.md)     |  Converts a text string that represents a number to a number.       |
